/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class OutpaceOblivionEffect
extends OneShotEffect {
    OutpaceOblivionEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 2 damage to each player who doesn't have max speed";
    }

    private OutpaceOblivionEffect(OutpaceOblivionEffect effect) {
        super((OneShotEffect)effect);
    }

    public OutpaceOblivionEffect copy() {
        return new OutpaceOblivionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getSpeed() >= 4) continue;
            player.damage(2, source, game);
        }
        return true;
    }
}

