/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ClueArtifactToken;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.JunkToken;

class OverencumberedTokenEffect
extends OneShotEffect {
    OverencumberedTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "enchanted opponent creates a Clue token, a Food token, and a Junk token.";
    }

    private OverencumberedTokenEffect(OverencumberedTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public OverencumberedTokenEffect copy() {
        return new OverencumberedTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent overencumbered = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (overencumbered != null) {
            new ClueArtifactToken().putOntoBattlefield(1, game, source, overencumbered.getAttachedTo());
            new FoodToken().putOntoBattlefield(1, game, source, overencumbered.getAttachedTo());
            new JunkToken().putOntoBattlefield(1, game, source, overencumbered.getAttachedTo());
            return true;
        }
        return false;
    }
}

