/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OvergrowthElementalEffect
extends OneShotEffect {
    OvergrowthElementalEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature was an Elemental, put a +1/+1 counter on {this}";
    }

    private OvergrowthElementalEffect(OvergrowthElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public OvergrowthElementalEffect copy() {
        return new OvergrowthElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null || !permanent.hasSubtype(SubType.ELEMENTAL, game)) {
            return false;
        }
        return new AddCountersSourceEffect(CounterType.P1P1.createInstance()).apply(game, source);
    }
}

