/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SheepToken;

class OvinomancerEffect
extends OneShotEffect {
    OvinomancerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "That creature's controller creates a 0/1 green Sheep creature token";
    }

    private OvinomancerEffect(OvinomancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public OvinomancerEffect copy() {
        return new OvinomancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId;
        Permanent permanent;
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (targetId != null && (permanent = game.getPermanentOrLKIBattlefield(targetId)) != null && (controllerId = permanent.getControllerId()) != null) {
            new SheepToken().putOntoBattlefield(1, game, source, controllerId);
            return true;
        }
        return false;
    }
}

