/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OwenGradyRaptorTrainerEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>(Arrays.asList("Menace", "Trample", "Reach", "Haste"));

    OwenGradyRaptorTrainerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put your choice of a " + this.getChoicesAsString() + " counter on target Dinosaur";
    }

    protected OwenGradyRaptorTrainerEffect(OwenGradyRaptorTrainerEffect effect) {
        super((OneShotEffect)effect);
    }

    protected String getChoicesAsString() {
        StringBuilder sb = new StringBuilder();
        String[] choicesArray = choices.toArray(new String[0]);
        for (int i = 0; i < choices.size(); ++i) {
            String separator = ", ";
            if (i == choices.size() - 2) {
                separator = ", or ";
            } else if (i == choices.size() - 1) {
                separator = "";
            }
            sb.append(choicesArray[i].toLowerCase()).append(separator);
        }
        return sb.toString();
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose " + this.getChoicesAsString() + " counter");
        choice.setChoices(choices);
        player.choose(this.outcome, (Choice)choice, game);
        String chosen = choice.getChoice();
        CounterType counterType = null;
        for (CounterType c : CounterType.values()) {
            if (!c.getName().equalsIgnoreCase(chosen)) continue;
            counterType = c;
        }
        if (counterType == null) {
            throw new IllegalArgumentException("Chosen counter type not found: " + chosen);
        }
        boolean applied = false;
        for (UUID target : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(target);
            if (permanent == null) continue;
            applied |= permanent.addCounters(counterType.createInstance(), source, game);
        }
        return applied;
    }

    public OwenGradyRaptorTrainerEffect copy() {
        return new OwenGradyRaptorTrainerEffect(this);
    }
}

