/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PainMagnificationTriggeredAbility
extends TriggeredAbilityImpl {
    public PainMagnificationTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1), false);
    }

    private PainMagnificationTriggeredAbility(PainMagnificationTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PainMagnificationTriggeredAbility copy() {
        return new PainMagnificationTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId()) && event.getAmount() >= 3) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent is dealt 3 or more damage by a single source, that player discards a card.";
    }
}

