/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.UUID;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SplitCard;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class PaintersServantEffect
extends ContinuousEffectImpl {
    PaintersServantEffect() {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "All cards that aren't on the battlefield, spells, and permanents are the chosen color in addition to their other colors";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ObjectColor color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
            if (color == null) {
                return false;
            }
            for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
                perm.getColor(game).addColor(color);
            }
            ArrayList<Card> affectedCards = new ArrayList<Card>();
            for (MageObject object : game.getStack()) {
                if (!(object instanceof Spell)) continue;
                game.getState().getCreateMageObjectAttribute(object, game).getColor().addColor(color);
                Card card2 = ((Spell)object).getCard();
                affectedCards.add(card2);
            }
            affectedCards.addAll(game.getExile().getCardsInRange(game, controller.getId()));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                affectedCards.addAll(game.getCommanderCardsFromCommandZone(player, CommanderCardType.ANY));
                affectedCards.addAll(player.getHand().getCards(game));
                affectedCards.addAll(player.getLibrary().getCards(game));
                affectedCards.addAll(player.getGraveyard().getCards(game));
            }
            affectedCards.forEach(card -> {
                ModalDoubleFacedCardHalf rightHalfCard;
                ModalDoubleFacedCardHalf leftHalfCard;
                game.getState().getCreateMageObjectAttribute((MageObject)card, game).getColor().addColor(color);
                if (card instanceof ModalDoubleFacedCard) {
                    leftHalfCard = ((ModalDoubleFacedCard)card).getLeftHalfCard();
                    rightHalfCard = ((ModalDoubleFacedCard)card).getRightHalfCard();
                    game.getState().getCreateMageObjectAttribute((MageObject)leftHalfCard, game).getColor().addColor(color);
                    game.getState().getCreateMageObjectAttribute((MageObject)rightHalfCard, game).getColor().addColor(color);
                }
                if (card instanceof SplitCard) {
                    leftHalfCard = ((SplitCard)card).getLeftHalfCard();
                    rightHalfCard = ((SplitCard)card).getRightHalfCard();
                    game.getState().getCreateMageObjectAttribute((MageObject)leftHalfCard, game).getColor().addColor(color);
                    game.getState().getCreateMageObjectAttribute((MageObject)rightHalfCard, game).getColor().addColor(color);
                }
                if (card.getSecondCardFace() != null) {
                    game.getState().getCreateMageObjectAttribute((MageObject)card.getSecondCardFace(), game).getColor().addColor(color);
                }
            });
            return true;
        }
        return false;
    }

    public PaintersServantEffect copy() {
        return new PaintersServantEffect(this);
    }

    private PaintersServantEffect(PaintersServantEffect effect) {
        super((ContinuousEffectImpl)effect);
    }
}

