/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class PanopticMirrorExileEffect
extends OneShotEffect {
    PanopticMirrorExileEffect() {
        super(Outcome.Exile);
        this.staticText = "You may exile an instant or sorcery card with mana value X from your hand";
    }

    private PanopticMirrorExileEffect(PanopticMirrorExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public PanopticMirrorExileEffect copy() {
        return new PanopticMirrorExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        int count = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("instant or sorcery card with mana value equal to " + count);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, count));
        String choiceText = "Exile a " + filter.getMessage() + " from your hand?";
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().count((FilterCard)filter, game) == 0 || !player.chooseUse(this.outcome, choiceText, source, game)) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
        if (player.choose(Outcome.PlayForFree, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            card.moveToExile(CardUtil.getCardExileZoneId((Game)game, (Ability)source), "Panoptic Mirror", source, game);
            Permanent PanopticMirror2 = game.getPermanent(source.getSourceId());
            if (PanopticMirror2 != null) {
                PanopticMirror2.imprint(card.getId(), game);
            }
            return true;
        }
        return false;
    }
}

