/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.cards.p.PanopticProjektorWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class PanopticProjektorEffect
extends CostModificationEffectImpl {
    private int spellsCast;

    PanopticProjektorEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next face-down creature spell you cast this turn costs {3} less to cast";
    }

    private PanopticProjektorEffect(PanopticProjektorEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        PanopticProjektorWatcher watcher = (PanopticProjektorWatcher)game.getState().getWatcher(PanopticProjektorWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getCount(source.getControllerId());
        }
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        PanopticProjektorWatcher watcher = (PanopticProjektorWatcher)game.getState().getWatcher(PanopticProjektorWatcher.class);
        if (watcher == null) {
            return false;
        }
        if (watcher.getCount(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard != null && ((SpellAbility)abilityToModify).getSpellAbilityCastMode().isFaceDown();
    }

    public PanopticProjektorEffect copy() {
        return new PanopticProjektorEffect(this);
    }
}

