/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class PanopticProjektorWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    PanopticProjektorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell != null && spell.isCreature(game) && spell.isFaceDown(game)) {
            this.playerMap.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    int getCount(UUID playerId) {
        return this.playerMap.getOrDefault(playerId, 0);
    }
}

