/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ParadigmShiftExileLibraryEffect
extends OneShotEffect {
    ParadigmShiftExileLibraryEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all cards from your library. Then shuffle your graveyard into your library";
    }

    private ParadigmShiftExileLibraryEffect(ParadigmShiftExileLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParadigmShiftExileLibraryEffect copy() {
        return new ParadigmShiftExileLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int count = controller.getLibrary().size();
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, count));
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            for (Card card : controller.getGraveyard().getCards(game)) {
                controller.moveCardToLibraryWithInfo(card, source, game, Zone.GRAVEYARD, true, true);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

