/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.ParadoxHazeEffect;
import mage.cards.p.ParadoxHazeWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ParadoxHazeTriggeredAbility
extends TriggeredAbilityImpl {
    ParadoxHazeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ParadoxHazeEffect(), false);
    }

    private ParadoxHazeTriggeredAbility(ParadoxHazeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ParadoxHazeTriggeredAbility copy() {
        return new ParadoxHazeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        if (permanent == null || !game.isActivePlayer(permanent.getAttachedTo()) || ((ParadoxHazeWatcher)game.getState().getWatcher(ParadoxHazeWatcher.class)).conditionMet()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent.getAttachedTo()));
        return true;
    }

    public String getRule() {
        return "At the beginning of enchanted player's first upkeep each turn, that player gets an additional upkeep step after this step.";
    }
}

