/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ParapetThrasherDamageEffect
extends OneShotEffect {
    ParapetThrasherDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "This creature deals 4 damage to each other opponent";
    }

    private ParapetThrasherDamageEffect(ParapetThrasherDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParapetThrasherDamageEffect copy() {
        return new ParapetThrasherDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID damagedOpponent = this.getTargetPointer().getFirst(game, source);
        MageObject object = game.getObject(source);
        if (object != null && damagedOpponent != null) {
            for (UUID playerId : game.getOpponents(source.getControllerId())) {
                Player opponent;
                if (Objects.equals(playerId, damagedOpponent) || (opponent = game.getPlayer(playerId)) == null) continue;
                int dealtDamage = opponent.damage(4, source.getSourceId(), source, game);
                game.informPlayers(object.getLogName() + " deals " + dealtDamage + " damage to " + opponent.getLogName());
            }
            return true;
        }
        return false;
    }
}

