/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PathOfPeaceEffect
extends OneShotEffect {
    PathOfPeaceEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. Its owner gains 4 life";
    }

    private PathOfPeaceEffect(PathOfPeaceEffect effect) {
        super((OneShotEffect)effect);
    }

    public PathOfPeaceEffect copy() {
        return new PathOfPeaceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && target != null) {
            target.destroy(source, game, false);
            Player owner = game.getPlayer(target.getOwnerId());
            if (owner != null) {
                owner.gainLife(4, game, source);
            }
            return true;
        }
        return false;
    }
}

