/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PathOfThePyromancerEffect
extends OneShotEffect {
    PathOfThePyromancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard all the cards in your hand. Add {R} for each card discarded this way, then draw that many cards plus one";
    }

    private PathOfThePyromancerEffect(PathOfThePyromancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PathOfThePyromancerEffect copy() {
        return new PathOfThePyromancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int discarded = player.discard(player.getHand(), false, source, game).size();
        player.getManaPool().addMana(Mana.RedMana((int)discarded), game, source);
        player.drawCards(discarded + 1, source, game);
        return true;
    }
}

