/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PeaceTalksCantAttackEffect
extends RestrictionEffect {
    int startedTurnNum = 0;

    public PeaceTalksCantAttackEffect() {
        super(Duration.Custom);
        this.staticText = "Creatures can't attack this turn and next turn";
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.startedTurnNum = game.getTurnNum();
    }

    private PeaceTalksCantAttackEffect(PeaceTalksCantAttackEffect effect) {
        super((RestrictionEffect)effect);
        this.startedTurnNum = effect.startedTurnNum;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isCreature(game);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public PeaceTalksCantAttackEffect copy() {
        return new PeaceTalksCantAttackEffect(this);
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getTurnNum() > this.startedTurnNum + 1) {
            this.discard();
            return true;
        }
        return false;
    }
}

