/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class PendantOfProsperityEffect
extends OneShotEffect {
    private static final Effect effect1 = new DrawCardSourceControllerEffect(1);
    private static final Effect effect2 = new PutCardFromHandOntoBattlefieldEffect((FilterCard)StaticFilters.FILTER_CARD_LAND_A);

    PendantOfProsperityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card, then you may put a land card from your hand onto the battlefield. {this}'s owner draws a card, then that player may put a land card from their hand onto the battlefield.";
    }

    private PendantOfProsperityEffect(PendantOfProsperityEffect effect) {
        super((OneShotEffect)effect);
    }

    public PendantOfProsperityEffect copy() {
        return new PendantOfProsperityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        effect1.apply(game, source);
        effect2.apply(game, source);
        Player player = game.getPlayer(game.getOwnerId((MageObject)game.getPermanent(source.getSourceId())));
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        if (!player.chooseUse(this.outcome, "Put a land into play from your hand?", source, game)) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND_A);
        if (!player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game)) {
            return true;
        }
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        return true;
    }
}

