/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class PermeatingMassEffect
extends OneShotEffect {
    PermeatingMassEffect() {
        super(Outcome.Copy);
        this.staticText = "that creature becomes a copy of {this}.";
    }

    private PermeatingMassEffect(PermeatingMassEffect effect) {
        super((OneShotEffect)effect);
    }

    public PermeatingMassEffect copy() {
        return new PermeatingMassEffect(this);
    }

    public boolean apply(Game game, Ability ability) {
        Permanent copyFrom;
        Permanent copyTo = game.getPermanent(this.getTargetPointer().getFirst(game, ability));
        if (copyTo != null && (copyFrom = ability.getSourcePermanentOrLKI(game)) != null) {
            game.copyPermanent(Duration.Custom, copyFrom, copyTo.getId(), ability, (CopyApplier)new EmptyCopyApplier());
        }
        return true;
    }
}

