/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.p.PerplexingChimeraControlEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PerplexingChimeraControlExchangeEffect
extends OneShotEffect {
    PerplexingChimeraControlExchangeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exchange control of {this} and that spell. If you do, you may choose new targets for the spell";
    }

    private PerplexingChimeraControlExchangeEffect(PerplexingChimeraControlExchangeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerplexingChimeraControlExchangeEffect copy() {
        return new PerplexingChimeraControlExchangeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (spell != null && controller != null) {
            Player spellCaster = game.getPlayer(spell.getControllerId());
            spell.setControllerId(controller.getId());
            spell.chooseNewTargets(game, controller.getId());
            game.informPlayers(controller.getLogName() + " got control of " + spell.getName() + " spell.");
            if (spellCaster != null) {
                PerplexingChimeraControlEffect effect = new PerplexingChimeraControlEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(spellCaster.getId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return false;
    }
}

