/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PerplexingChimeraControlExchangeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PerplexingChimeraTriggeredAbility
extends TriggeredAbilityImpl {
    public PerplexingChimeraTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PerplexingChimeraControlExchangeEffect(), true);
        this.setTriggerPhrase("Whenever an opponent casts a spell, ");
    }

    private PerplexingChimeraTriggeredAbility(PerplexingChimeraTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public PerplexingChimeraTriggeredAbility copy() {
        return new PerplexingChimeraTriggeredAbility(this);
    }
}

