/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PetraSphinxEffect
extends OneShotEffect {
    PetraSphinxEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target player chooses a card name, then reveals the top card of their library. If that card has the chosen name, that player puts it into their hand. If it doesn't, the player puts it into their graveyard";
    }

    private PetraSphinxEffect(PetraSphinxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null || !player.getLibrary().hasCards()) {
            return true;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(player, game, source, false);
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return true;
        }
        CardsImpl cards = new CardsImpl(card);
        player.revealCards(source, (Cards)cards, game);
        if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        } else {
            player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        return true;
    }

    public PetraSphinxEffect copy() {
        return new PetraSphinxEffect(this);
    }
}

