/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.DamageDoneWatcher;

class PetrifiedWoodKinEffect
extends OneShotEffect {
    PetrifiedWoodKinEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "";
    }

    private PetrifiedWoodKinEffect(PetrifiedWoodKinEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        DamageDoneWatcher watcher = (DamageDoneWatcher)game.getState().getWatcher(DamageDoneWatcher.class);
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (player == null || watcher == null || permanent == null) {
            return false;
        }
        ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
        int amount = 0;
        for (UUID opponentId : game.getOpponents(player.getId())) {
            MageObjectReference mor = new MageObjectReference(opponentId, game);
            amount += watcher.getDamagedObjects().getOrDefault(mor, 0).intValue();
        }
        permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game, (List)appliedEffects);
        return true;
    }

    public PetrifiedWoodKinEffect copy() {
        return new PetrifiedWoodKinEffect(this);
    }
}

