/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.abilities.keyword.DisturbAbility;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class PhantomCarriageEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterCard("card with flashback or disturb");

    public PhantomCarriageEffect() {
        super(new TargetCardInLibrary(filter), Outcome.Neutral);
        this.staticText = "search your library for a card with flashback or disturb, put it into your graveyard, then shuffle";
    }

    private PhantomCarriageEffect(PhantomCarriageEffect effect) {
        super((SearchEffect)effect);
    }

    public PhantomCarriageEffect copy() {
        return new PhantomCarriageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            if (controller.searchLibrary(this.target, source, game) && !this.target.getTargets().isEmpty() && (card = controller.getLibrary().getCard(this.target.getFirstTarget(), game)) != null) {
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)new AbilityPredicate(FlashbackAbility.class), (Predicate)new AbilityPredicate(DisturbAbility.class)));
    }
}

