/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;
import mage.util.functions.CopyTokenFunction;

class PhantomSteedEffect
extends OneShotEffect {
    PhantomSteedEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a tapped and attacking token that's a copy of the exiled card, except it's an Illusion in addition to its other types. Sacrifice that token at end of combat";
    }

    private PhantomSteedEffect(PhantomSteedEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhantomSteedEffect copy() {
        return new PhantomSteedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ExileZone exileZone = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        for (Card card : exileZone.getCards(game)) {
            Token token = CopyTokenFunction.createTokenCopy((Card)card, (Game)game);
            token.addSubType(new SubType[]{SubType.ILLUSION});
            token.putOntoBattlefield(1, game, source, source.getControllerId(), true, true);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)new ExileTargetEffect("Sacrifice that token at end of combat").setTargetPointer((TargetPointer)new FixedTargets(token, game))), source);
        }
        return true;
    }
}

