/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.PharikaSnakeToken;
import mage.players.Player;

class PharikaExileEffect
extends OneShotEffect {
    PharikaExileEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile target creature card from a graveyard. Its owner creates a 1/1 black and green Snake enchantment creature token with deathtouch";
    }

    private PharikaExileEffect(PharikaExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player tokenController;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card targetCard = game.getCard(source.getFirstTarget());
        if (targetCard == null) {
            return false;
        }
        if (game.getState().getZone(source.getFirstTarget()) == Zone.GRAVEYARD) {
            controller.moveCards(targetCard, Zone.EXILED, source, game);
        }
        if ((tokenController = game.getPlayer(targetCard.getOwnerId())) == null) {
            return false;
        }
        return new PharikaSnakeToken().putOntoBattlefield(1, game, source, tokenController.getId());
    }

    public PharikaExileEffect copy() {
        return new PharikaExileEffect(this);
    }
}

