/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class PhialOfGaladrielDrawEffect
extends ReplacementEffectImpl {
    PhialOfGaladrielDrawEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If you would draw a card while you have no cards in hand, draw two cards instead";
    }

    private PhialOfGaladrielDrawEffect(PhialOfGaladrielDrawEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PhialOfGaladrielDrawEffect copy() {
        return new PhialOfGaladrielDrawEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(2, source, game, event);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID playerId = source.getControllerId();
        if (playerId == null || !event.getPlayerId().equals(playerId)) {
            return false;
        }
        Player player = game.getPlayer(playerId);
        if (player == null) {
            return false;
        }
        return player.getHand().size() == 0;
    }
}

