/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PhyresisOutbreakEffect
extends OneShotEffect {
    PhyresisOutbreakEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "each creature your opponents control gets -1/-1 until end of turn for each poison counter its controller has";
    }

    private PhyresisOutbreakEffect(PhyresisOutbreakEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyresisOutbreakEffect copy() {
        return new PhyresisOutbreakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId(), true)) {
            int totalPoison = game.getPlayer(opponentId).getCountersCount(CounterType.POISON);
            BoostTargetEffect effect = new BoostTargetEffect(totalPoison * -1, totalPoison * -1, Duration.EndOfTurn);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE, opponentId, game)) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

