/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class PhyrexianCensorWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    PhyrexianCensorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && !spell.hasSubtype(SubType.PHYREXIAN, game)) {
            this.map.compute(spell.getControllerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    public static boolean checkPlayer(UUID playerId, Game game) {
        return ((PhyrexianCensorWatcher)game.getState().getWatcher(PhyrexianCensorWatcher.class)).map.getOrDefault(playerId, 0) > 0;
    }
}

