/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.abilities.effects.common.combat.CantAttackBlockUnlessPaysSourceEffect;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PhyrexianMarauderCantAttackUnlessYouPayEffect
extends CantAttackBlockUnlessPaysSourceEffect {
    PhyrexianMarauderCantAttackUnlessYouPayEffect() {
        super((ManaCosts)new ManaCostsImpl("{0}"), PayCostToAttackBlockEffectImpl.RestrictType.ATTACK);
        this.staticText = "{this} can't attack unless you pay {1} for each +1/+1 counter on it";
    }

    private PhyrexianMarauderCantAttackUnlessYouPayEffect(PhyrexianMarauderCantAttackUnlessYouPayEffect effect) {
        super((CantAttackBlockUnlessPaysSourceEffect)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getSourceId());
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        int counter;
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject != null && (counter = sourceObject.getCounters(game).getCount(CounterType.P1P1)) > 0) {
            return new ManaCostsImpl("{" + counter + '}');
        }
        return null;
    }

    public PhyrexianMarauderCantAttackUnlessYouPayEffect copy() {
        return new PhyrexianMarauderCantAttackUnlessYouPayEffect(this);
    }
}

