/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PhyrexianProcessorPayLifeEffect
extends OneShotEffect {
    PhyrexianProcessorPayLifeEffect() {
        super(Outcome.LoseLife);
        this.staticText = "pay any amount of life.";
    }

    private PhyrexianProcessorPayLifeEffect(PhyrexianProcessorPayLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianProcessorPayLifeEffect copy() {
        return new PhyrexianProcessorPayLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        int payAmount = controller.getAmount(0, controller.getLife(), "Pay any amount of life", source, game);
        PayLifeCost cost = new PayLifeCost(payAmount);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        Card sourceCard = game.getCard(source.getSourceId());
        game.informPlayers((sourceCard != null ? sourceCard.getName() : "") + ": " + controller.getLogName() + " pays " + payAmount + " life.");
        String key = CardUtil.getCardZoneString((String)"lifePaid", (UUID)source.getSourceId(), (Game)game);
        game.getState().setValue(key, (Object)payAmount);
        permanent.addInfo("life paid", CardUtil.addToolTipMarkTags((String)("Life paid: " + payAmount)), game);
        return true;
    }
}

