/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.ShadowAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.p.PhyrexianSplicerCardHint;
import mage.cards.p.PhyrexianSplicerChooseCost;
import mage.cards.p.PhyrexianSplicerEffect;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.other.AnotherTargetPredicate;
import mage.target.TargetPermanent;

public final class PhyrexianSplicer
extends CardImpl {
    static final FilterCreaturePermanent filterLose = new FilterCreaturePermanent("creature with the chosen ability");
    private static final FilterCreaturePermanent filterGain = new FilterCreaturePermanent("another target creature");

    public PhyrexianSplicer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new PhyrexianSplicerEffect(), (Cost)new ManaCostsImpl("{2}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new PhyrexianSplicerChooseCost());
        ability.addTarget(new TargetPermanent((FilterPermanent)filterLose).withChooseHint("to lose ability").setTargetTag(1));
        ability.addTarget(new TargetPermanent((FilterPermanent)filterGain).withChooseHint("to gain ability").setTargetTag(2));
        ability.addHint((Hint)PhyrexianSplicerCardHint.instance);
        this.addAbility((Ability)ability);
    }

    private PhyrexianSplicer(PhyrexianSplicer card) {
        super((CardImpl)card);
    }

    public PhyrexianSplicer copy() {
        return new PhyrexianSplicer(this);
    }

    static {
        filterLose.add(Predicates.or((Predicate[])new Predicate[]{new AbilityPredicate(FlyingAbility.class), new AbilityPredicate(FirstStrikeAbility.class), new AbilityPredicate(TrampleAbility.class), new AbilityPredicate(ShadowAbility.class)}));
        filterLose.add((ObjectSourcePlayerPredicate)new AnotherTargetPredicate(1));
        filterGain.add((ObjectSourcePlayerPredicate)new AnotherTargetPredicate(2));
    }
}

