/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;

class PhyrexianUnlifeEffect
extends ReplacementEffectImpl {
    private int lastCheckedDamageStepNum = 0;
    private boolean startedWithLifeAboveZero = false;

    PhyrexianUnlifeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As long as you have 0 or less life, all damage is dealt to you as though its source had infect";
    }

    private PhyrexianUnlifeEffect(PhyrexianUnlifeEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.lastCheckedDamageStepNum = effect.lastCheckedDamageStepNum;
        this.startedWithLifeAboveZero = effect.startedWithLifeAboveZero;
    }

    public PhyrexianUnlifeEffect copy() {
        return new PhyrexianUnlifeEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((DamageEvent)event).setAsThoughInfect(true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (((DamageEvent)event).isCombatDamage()) {
            if (this.lastCheckedDamageStepNum != game.getState().getStepNum()) {
                this.lastCheckedDamageStepNum = game.getState().getStepNum();
                boolean bl = this.startedWithLifeAboveZero = player.getLife() > 0;
            }
            if (this.startedWithLifeAboveZero) {
                return false;
            }
        }
        return player.getLife() < 1;
    }
}

