/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PitOfOfferingsEffect
extends OneShotEffect {
    static UUID getExileZoneId(MageObject sourceObject, Game game) {
        if (sourceObject == null) {
            return null;
        }
        return CardUtil.getExileZoneId((String)CardUtil.getObjectZoneString((String)"_pitOfOfferingExile", (UUID)sourceObject.getId(), (Game)game, (int)sourceObject.getZoneChangeCounter(game), (boolean)false), (Game)game);
    }

    public PitOfOfferingsEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to three target cards from graveyards";
    }

    private PitOfOfferingsEffect(PitOfOfferingsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cardsExiled = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        controller.moveCardsToExile(cardsExiled.getCards(game), source, game, true, PitOfOfferingsEffect.getExileZoneId(sourceObject, game), sourceObject.getIdName());
        return true;
    }

    public PitOfOfferingsEffect copy() {
        return new PitOfOfferingsEffect(this);
    }
}

