/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class PithingNeedleEffect
extends ContinuousRuleModifyingEffectImpl {
    PithingNeedleEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Activated abilities of sources with the chosen name can't be activated unless they're mana abilities";
    }

    private PithingNeedleEffect(PithingNeedleEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public PithingNeedleEffect copy() {
        return new PithingNeedleEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
        return ability.isPresent() && object != null && game.getState().getPlayersInRange(source.getControllerId(), game).contains((Object)event.getPlayerId()) && !((Ability)ability.get()).isManaActivatedAbility() && CardUtil.haveSameNames((MageObject)object, (String)cardName, (Game)game);
    }
}

