/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class PitilessCarnageEffect
extends OneShotEffect {
    PitilessCarnageEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of permanents you control, then draw that many cards";
    }

    private PitilessCarnageEffect(PitilessCarnageEffect effect) {
        super((OneShotEffect)effect);
    }

    public PitilessCarnageEffect copy() {
        return new PitilessCarnageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENTS);
        player.choose(this.outcome, (Target)target, source, game);
        Set permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent : permanents) {
            permanent.sacrifice(source, game);
        }
        player.drawCards(permanents.size(), source, game);
        return true;
    }
}

