/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PlagueFiendEffect
extends OneShotEffect {
    protected Cost cost;

    public PlagueFiendEffect(Cost cost) {
        super(Outcome.Detriment);
        this.staticText = "destroy that creature unless its controller pays {2}";
        this.cost = cost;
    }

    private PlagueFiendEffect(PlagueFiendEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public PlagueFiendEffect copy() {
        return new PlagueFiendEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null && (player = game.getPlayer(targetCreature.getControllerId())) != null) {
                this.cost.clearPaid();
                StringBuilder sb = new StringBuilder("Pay {2}? (Otherwise ").append(targetCreature.getName()).append(" will be destroyed)");
                if (player.chooseUse(Outcome.Benefit, sb.toString(), source, game)) {
                    this.cost.pay(source, game, source, targetCreature.getControllerId(), false, null);
                }
                if (!this.cost.isPaid()) {
                    targetCreature.destroy(source, game, false);
                }
            }
            return true;
        }
        return false;
    }
}

