/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PlanarGenesisEffect
extends LookLibraryAndPickControllerEffect {
    PlanarGenesisEffect() {
        super(4, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND, PutCards.BATTLEFIELD_TAPPED, PutCards.BOTTOM_RANDOM, true);
        this.staticText = "Look at the top four cards of your library. You may put a land card from among them onto the battlefield tapped. If you don't, put a card from among them into your hand. Put the rest on the bottom of your library in a random order.";
    }

    private PlanarGenesisEffect(PlanarGenesisEffect effect) {
        super((LookLibraryAndPickControllerEffect)effect);
    }

    public PlanarGenesisEffect copy() {
        return new PlanarGenesisEffect(this);
    }

    protected boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        boolean result = this.putPickedCards.moveCards(player, pickedCards, source, game);
        if (pickedCards.isEmpty() && otherCards.size() >= 1) {
            TargetCard target = new TargetCard(0, 1, Zone.LIBRARY, StaticFilters.FILTER_CARD);
            target.withChooseHint("to put " + PutCards.HAND.getMessage(false, false));
            if (player.chooseTarget(PutCards.HAND.getOutcome(), otherCards, target, source, game)) {
                CardsImpl toPutInHand = new CardsImpl((Collection)target.getTargets());
                result |= PutCards.HAND.moveCards(player, (Cards)toPutInHand, source, game);
            }
        }
        otherCards.retainZone(Zone.LIBRARY, game);
        return result |= this.putLookedCards.moveCards(player, otherCards, source, game);
    }
}

