/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class PlarggAndNassariEffect
extends OneShotEffect {
    PlarggAndNassariEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles cards from the top of their library until they exile a nonland card. An opponent chooses a nonland card exiled this way. You may cast up to two spells from among the other cards exiled this way without paying their mana costs";
    }

    private PlarggAndNassariEffect(PlarggAndNassariEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlarggAndNassariEffect copy() {
        return new PlarggAndNassariEffect(this);
    }

    private static Player getOpponent(Player controller, Ability source, Game game) {
        Set opponents = game.getOpponents(controller.getId());
        if (opponents.size() < 2) {
            return game.getPlayer((UUID)RandomUtil.randomFromCollection((Collection)opponents));
        }
        TargetOpponent target = new TargetOpponent(true);
        controller.choose(Outcome.Neutral, (Target)target, source, game);
        return game.getPlayer(target.getFirstTarget());
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        block0: for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (Card card : player.getLibrary().getCards(game)) {
                cards.add(card);
                player.moveCards(card, Zone.EXILED, source, game);
                if (card.isLand(game)) continue;
                continue block0;
            }
        }
        if (cards.isEmpty()) {
            return false;
        }
        Player opponent = PlarggAndNassariEffect.getOpponent(controller, source, game);
        if (opponent != null) {
            TargetCardInExile target = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
            target.withNotTarget(true);
            opponent.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            cards.remove(game.getCard(target.getFirstTarget()));
        }
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD, (int)2);
        return true;
    }
}

