/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfMainPhaseDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.AddManaInAnyCombinationEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.stack.Spell;

class PlasmCaptureCounterEffect
extends OneShotEffect {
    PlasmCaptureCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. At the beginning of your next first main phase, add X mana in any combination of colors, where X is that spell's mana value";
    }

    private PlasmCaptureCounterEffect(PlasmCaptureCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlasmCaptureCounterEffect copy() {
        return new PlasmCaptureCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
            int mana = spell.getManaValue();
            AtTheBeginOfMainPhaseDelayedTriggeredAbility delayedAbility = new AtTheBeginOfMainPhaseDelayedTriggeredAbility((Effect)new AddManaInAnyCombinationEffect(mana), false, TargetController.YOU, AtTheBeginOfMainPhaseDelayedTriggeredAbility.PhaseSelection.NEXT_PRECOMBAT_MAIN);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

