/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PlayWithFireEffect
extends OneShotEffect {
    PlayWithFireEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to any target. If a player is dealt damage this way, scry 1. <i>(Look at the top card of your library. You may put that card on the bottom of your library.)</i>";
    }

    private PlayWithFireEffect(PlayWithFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlayWithFireEffect copy() {
        return new PlayWithFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            return permanent.damage(2, source.getSourceId(), source, game) > 0;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null || player.damage(2, source.getSourceId(), source, game) < 1) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.scry(1, source, game);
        }
        return true;
    }
}

