/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopySourceSpellEffect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.target.common.TargetSacrifice;

class PlumbTheForbiddenCost
extends SacrificeTargetCost {
    PlumbTheForbiddenCost() {
        super(new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES));
        this.text = "you may sacrifice one or more creatures. When you do, copy this spell for each creature sacrificed this way";
    }

    private PlumbTheForbiddenCost(PlumbTheForbiddenCost cost) {
        super((SacrificeTargetCost)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (!super.pay(ability, game, source, controllerId, noMana, costToPay)) {
            return false;
        }
        int sacrificed = this.getPermanents().size();
        if (sacrificed > 0) {
            game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new CopySourceSpellEffect(sacrificed), false, "when you do, copy this spell for each creature sacrificed this way"), source);
        }
        return true;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    public PlumbTheForbiddenCost copy() {
        return new PlumbTheForbiddenCost(this);
    }
}

