/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class PointTheWayEffect
extends OneShotEffect {
    PointTheWayEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to X basic land cards, where X is your speed. Put those cards onto the battlefield tapped, then shuffle";
    }

    private PointTheWayEffect(PointTheWayEffect effect) {
        super((OneShotEffect)effect);
    }

    public PointTheWayEffect copy() {
        return new PointTheWayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, player.getSpeed(), (FilterCard)StaticFilters.FILTER_CARD_BASIC_LANDS);
        player.searchLibrary(target, source, game);
        Set cards = target.getTargets().stream().map(uuid -> player.getLibrary().getCard(uuid, game)).collect(Collectors.toSet());
        player.moveCards(cards, Zone.BATTLEFIELD, source, game, true, false, false, null);
        player.shuffleLibrary(source, game);
        return true;
    }
}

