/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;
import mage.target.common.TargetSacrifice;

class PolygraphOrbEffect
extends OneShotEffect {
    PolygraphOrbEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent loses 3 life unless they discard a card or sacrifice a creature";
    }

    private PolygraphOrbEffect(PolygraphOrbEffect effect) {
        super((OneShotEffect)effect);
    }

    public PolygraphOrbEffect copy() {
        return new PolygraphOrbEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashMap<UUID, Card> chosenCards = new HashMap<UUID, Card>();
        for (UUID uUID : game.getOpponents(controller.getId())) {
            opponent = game.getPlayer(uUID);
            if (opponent == null) continue;
            TargetDiscard targetDiscard = new TargetDiscard(0, 1, StaticFilters.FILTER_CARD_A, uUID);
            targetDiscard.withChooseHint("otherwise you have to sacrifice a creature or lose 3 life");
            if (opponent.choose(Outcome.PreventDamage, (Target)targetDiscard, source, game)) {
                chosenCards.put(uUID, game.getCard(targetDiscard.getFirstTarget()));
                continue;
            }
            TargetSacrifice targetSacrifice = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE);
            targetSacrifice.withChooseHint("otherwise you lose 3 life");
            if (opponent.choose(Outcome.PreventDamage, (Target)targetSacrifice, source, game)) {
                chosenCards.put(uUID, game.getCard(targetSacrifice.getFirstTarget()));
                continue;
            }
            chosenCards.put(uUID, null);
        }
        for (Map.Entry entry : chosenCards.entrySet()) {
            opponent = game.getPlayer((UUID)entry.getKey());
            if (opponent == null) continue;
            if (entry.getValue() != null) {
                Permanent permanent;
                Card card = (Card)entry.getValue();
                Zone zone = game.getState().getZone(card.getId());
                if (Zone.HAND.match(zone)) {
                    opponent.discard(card, false, source, game);
                    continue;
                }
                if (Zone.BATTLEFIELD.match(zone) && (permanent = game.getPermanent(card.getId())) != null) {
                    permanent.sacrifice(source, game);
                    continue;
                }
            }
            opponent.loseLife(3, game, source, false);
        }
        return true;
    }
}

