/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class PopularEntertainerAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    PopularEntertainerAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GoadTargetEffect(), false);
    }

    private PopularEntertainerAbility(PopularEntertainerAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PopularEntertainerAbility copy() {
        return new PopularEntertainerAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage() || event.getAmount() <= 0) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && this.isControlledBy(permanent.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(event.getTargetId());
        if (player == null || this.getFilteredEvents((BatchEvent)((DamagedBatchForOnePlayerEvent)event), game).isEmpty()) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature controlled by " + player.getName());
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        this.getTargets().clear();
        this.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        return true;
    }

    public String getRule() {
        return "Whenever one or more creatures you control deal combat damage to a player, goad target creature that player controls.";
    }
}

