/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.cards.p.PortRazerWatcher;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PortRazerEffect
extends RestrictionEffect {
    PortRazerEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack a player it has already attacked this turn";
    }

    private PortRazerEffect(PortRazerEffect effect) {
        super((RestrictionEffect)effect);
    }

    public PortRazerEffect copy() {
        return new PortRazerEffect(this);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        PortRazerWatcher watcher = (PortRazerWatcher)game.getState().getWatcher(PortRazerWatcher.class);
        return watcher != null && watcher.checkAttacker(attacker, defenderId);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }
}

