/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.cards.p.PortcullisReturnToBattlefieldTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PortcullisExileEffect
extends OneShotEffect {
    PortcullisExileEffect() {
        super(Outcome.Exile);
        this.staticText = "exile that creature. Return that card to the battlefield under its owner's control when {this} leaves the battlefield";
    }

    private PortcullisExileEffect(PortcullisExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public PortcullisExileEffect copy() {
        return new PortcullisExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creatureToExile = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent portcullis = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (portcullis != null && creatureToExile != null && controller != null) {
            UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)creatureToExile.getId(), (int)creatureToExile.getZoneChangeCounter(game));
            controller.moveCardsToExile((Card)creatureToExile, source, game, true, exileZoneId, portcullis.getName());
            ReturnToBattlefieldUnderOwnerControlTargetEffect returnEffect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
            returnEffect.setTargetPointer((TargetPointer)new FixedTarget(creatureToExile.getId(), game.getState().getZoneChangeCounter(creatureToExile.getId())));
            PortcullisReturnToBattlefieldTriggeredAbility delayedAbility = new PortcullisReturnToBattlefieldTriggeredAbility(new FixedTarget(portcullis, game), (Effect)returnEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        }
        return true;
    }
}

