/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;

class PortcullisReturnToBattlefieldTriggeredAbility
extends DelayedTriggeredAbility {
    protected final FixedTarget fixedTarget;

    public PortcullisReturnToBattlefieldTriggeredAbility(FixedTarget fixedTarget, Effect effect) {
        super(effect, Duration.OneUse);
        this.fixedTarget = fixedTarget;
    }

    private PortcullisReturnToBattlefieldTriggeredAbility(PortcullisReturnToBattlefieldTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.fixedTarget = ability.fixedTarget.copy();
    }

    public PortcullisReturnToBattlefieldTriggeredAbility copy() {
        return new PortcullisReturnToBattlefieldTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((ZoneChangeEvent)event).getFromZone().match(Zone.BATTLEFIELD)) {
            return this.fixedTarget.getTarget().equals(event.getTargetId());
        }
        return false;
    }

    public String getRule() {
        return "Return this card to the battlefield under its owner's control when {this} leaves the battlefield.";
    }
}

