/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.p.PortentOfCalamityTarget;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PortentOfCalamityEffect
extends OneShotEffect {
    PortentOfCalamityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top X cards of your library. For each card type, you may exile a card of that type from among them. Put the rest into your graveyard. You may cast a spell from among the exiled cards without paying its mana cost if you exiled four or more cards this way. Then put the rest of the exiled cards into your hand";
    }

    private PortentOfCalamityEffect(PortentOfCalamityEffect effect) {
        super((OneShotEffect)effect);
    }

    public PortentOfCalamityEffect copy() {
        return new PortentOfCalamityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        player.revealCards(source, (Cards)cards, game);
        PortentOfCalamityTarget target = new PortentOfCalamityTarget();
        player.choose(Outcome.DrawCard, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl chosen = new CardsImpl((Collection)target.getTargets());
        player.moveCards((Cards)chosen, Zone.EXILED, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        if (chosen.size() >= 4) {
            TargetCard freeCast = new TargetCard(0, 1, Zone.EXILED, StaticFilters.FILTER_CARD);
            player.choose(Outcome.PlayForFree, (Cards)chosen, freeCast, source, game);
            MayCastTargetCardEffect effect = new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST);
            effect.setTargetPointer((TargetPointer)new FixedTarget(freeCast.getFirstTarget()));
            effect.apply(game, source);
        }
        chosen.retainZone(Zone.EXILED, game);
        player.moveCards((Cards)chosen, Zone.HAND, source, game);
        return true;
    }
}

