/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Library;
import mage.players.Player;

class PossibilityStormEffect
extends OneShotEffect {
    PossibilityStormEffect() {
        super(Outcome.Neutral);
        this.staticText = "that player exiles it, then exiles cards from the top of their library until they exile a card that shares a card type with it. That player may cast that card without paying its mana cost. Then they put all cards exiled with {this} on the bottom of their library in a random order";
    }

    private PossibilityStormEffect(PossibilityStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ExileZone exile;
        Card card;
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        boolean noLongerOnStack = false;
        if (spell == null) {
            spell = (Spell)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK);
            noLongerOnStack = true;
        }
        if (spell == null) {
            return false;
        }
        Player spellController = game.getPlayer(spell.getControllerId());
        if (spellController == null) {
            return false;
        }
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        if (!noLongerOnStack) {
            spellController.moveCardsToExile((Card)spell, source, game, true, source.getSourceId(), sourceObject.getIdName());
        }
        if (!spellController.getLibrary().hasCards()) {
            return true;
        }
        Library library = spellController.getLibrary();
        while ((card = library.getFromTop(game)) != null && spellController.moveCardsToExile(card, source, game, true, source.getSourceId(), sourceObject.getIdName()) && library.hasCards() && !this.sharesType(card, spell.getCardType(game), game)) {
        }
        if (card != null && this.sharesType(card, spell.getCardType(game), game) && !card.isLand(game) && card.getSpellAbility().canChooseTarget(game, spellController.getId()) && spellController.chooseUse(Outcome.PlayForFree, "Cast " + card.getLogName() + " without paying cost?", source, game)) {
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
            spellController.cast(spellController.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        }
        if ((exile = game.getExile().getExileZone(source.getSourceId())) != null) {
            spellController.putCardsOnBottomOfLibrary((Cards)exile, game, source, false);
        }
        return true;
    }

    private boolean sharesType(Card card, List<CardType> cardTypes, Game game) {
        for (CardType type : card.getCardType(game)) {
            if (!cardTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    public PossibilityStormEffect copy() {
        return new PossibilityStormEffect(this);
    }
}

