/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PossibilityTechnicianEffect
extends OneShotEffect {
    private static final Condition condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)new FilterControlledPermanent(SubType.KAVU));

    PossibilityTechnicianEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. For as long as that card remains exiled, you may play it if you control a Kavu";
    }

    private PossibilityTechnicianEffect(PossibilityTechnicianEffect effect) {
        super((OneShotEffect)effect);
    }

    public PossibilityTechnicianEffect copy() {
        return new PossibilityTechnicianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)false, (UUID)source.getControllerId(), (Condition)condition);
        return true;
    }
}

